// config: norepeat

#include "GetObjects.js"
#include "GetPoint.js"

function DoRotate()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEditPoints();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.hideUI( 'done' );	
	moi.ui.showUI( 'CenterPrompt' );
	moi.ui.showUI( 'RotateOptions' );
	moi.ui.endUIUpdate();

	var pointpicker = moi.ui.createPointPicker();
	if ( !GetPoint( pointpicker ) )
		return;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'CenterPrompt' );
	moi.ui.showUI( 'FirstRefPrompt' );
	moi.ui.showUI( 'AngleOptions' );
	moi.ui.endUIUpdate();

	var centerpickedpt = pointpicker.pt;

	var centerpt = pointpicker.ptframe;
	pointpicker.restrictToPlaneThroughPt( centerpt.origin, true );
	pointpicker.stickToSurfacesMode = 'min';
	pointpicker.disableVerticalStraightSnap = true;
	
	var factory = moi.command.createFactory( 'rotate' );
	factory.setInput( 0, objects );
	factory.setInput( 1, centerpt );
	
	// First UI line - from center point to first reference point.
	var ref1linefactory = moi.command.createFactory( 'line' );
	ref1linefactory.setInput( 0, centerpt.origin );

	// Second UI line - from center point to second reference point.
	var ref2linefactory = moi.command.createFactory( 'line' );
	ref2linefactory.setInput( 0, centerpt.origin );
	
	var HaveBasePt = false;
	var basept;

	var KeepGoing = true;
	while ( KeepGoing )
	{
		KeepGoing = false;

		// Set up point picker bindings.
		pointpicker.clearBindings();
		
		if ( !HaveBasePt )
		{
			// If we're still waiting for the base point, hook it up to the first ref line.
			pointpicker.bindResultPt( ref1linefactory.getInput(1) );
		}
		else
		{
			// Otherwise, hook it up to the factory, set the UI binding and hook it up to the
			// second ref line.
			pointpicker.bindResultPt( factory.getInput(4) );
			pointpicker.setBasePt( centerpickedpt );
			
			moi.ui.commandUI.g_Factory = factory;
			pointpicker.bindFunc( moi.ui.commandUI.OnPoint );

			pointpicker.bindResultPt( ref2linefactory.getInput(1) );
		}
		
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return;

			var makecopy = moi.ui.commandUI.makecopies.value;
			var iscomplete = false;
			
			if ( pointpicker.event == 'angleinput' )
			{
				// When we get an angle input, we can either spit out a copy or be finished.
				factory.setInput( 2, moi.ui.commandUI.angleinput.value );
				iscomplete = true;
			}
			else if ( pointpicker.event == 'finished' )
			{
				if ( !HaveBasePt )
				{
					// If this is the first reference point picked, then we have some setup to do.
				
					HaveBasePt = true;
					
					var frame = pointpicker.cplane;
					frame.origin = centerpt.origin;
					centerpt = frame;
			
					basept = pointpicker.pt;

					factory.setInput( 1, frame );
					factory.setInput( 3, basept );
			
					pointpicker.restrictToPlane( frame, true );
					pointpicker.setRadialIntersection( frame, basept );

					moi.ui.beginUIUpdate();
					moi.ui.hideUI( 'FirstRefPrompt' );
					moi.ui.showUI( 'SecondRefPrompt' );
					moi.ui.endUIUpdate();
		
					KeepGoing = true;
					break;
				}
				else
				{
					// If this is the second reference point, then we have enough to finish or create a copy.
				
					if ( pointpicker.controlDown )
						makecopy = true;
						
					if ( makecopy )
						moi.ui.removeLastPickedPoint();
						
					iscomplete = true;
				}
			}
			
			if ( iscomplete )
			{
				// We have enough info to either finish or to create a copy.
			
				if ( makecopy )
				{
					// Drop a copy and keep going.
					
					factory.reset();
					factory.setInput( 5, true );
					factory.update();
					factory.commit();
					
					// Set up a fresh factory to keep going.
					factory = moi.command.createFactory( 'rotate' );
					factory.setInput( 0, objects );
					factory.setInput( 1, centerpt );
					factory.setInput( 3, basept );
					factory.setInput( 4, pointpicker.pt );
					factory.update();
					
					KeepGoing = true;
				}
				
				break;
			}
		}
	}

	factory.update();
	factory.commit();
}

DoRotate();
